<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ClientQueryNotification extends Notification
{
    use Queueable;
    public $clientQueryData;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($clientQueryData)
    {
        $this->clientQueryData = $clientQueryData;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
        ->subject($this->clientQueryData['subject'])
        ->line('Client Name: '. $this->clientQueryData['name'])
        ->line('Email: '. $this->clientQueryData['email'])
        ->line('Message: '.$this->clientQueryData['message']);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
